#inputentry_inc.py
'''
１行入力用ウィンドウ
Entryを使用
タイトル、メッセージ、初期値、エントリーの長さを指定
前後の空白は除去して返す
'''
from tkinter import *
import tkinter.simpledialog as smpl

class inentry():
  def __init__(self,parent=None,title=None,msg=None,inistr='',leng=20):
    self.parent = parent
    self.msg = msg
    self.inistr = inistr
    self.leng = leng
    self.result = ''
    self.root = Tk()
    if title:
      self.root.title(title)
    else:
      self.root.title('一行入力')
    self.body(self.root)

  def body(self,root):
    msgfr = Frame(root)
    entryfr = Frame(root)
    btnfr = Frame(root)

    msg = Label(msgfr,text=self.msg)
    msg.pack()
    msgfr.pack(padx=5)

    self.entry = Entry(entryfr,width=self.leng)
    if self.inistr:
      self.entry.insert(0,self.inistr)
    self.entry.pack()
    entryfr.pack(padx=5)

    okbtn = Button(btnfr,text='OK',command=self.ok)
    cancelbtn = Button(btnfr,text='Cancel',command=self.cancel)
    okbtn.pack(side=LEFT)
    cancelbtn.pack()
    btnfr.pack(pady=10)

    self.setprotocol()

  def ok(self):
    self.result = self.entry.get().strip()
    self.cancel()

  def cancel(self):
    self.root.destroy()

  def on_closing(self):
    #ｘボタンが押されたとき
    self.cancel()
    
  #終了処理制御
  def setprotocol(self):
    self.root.protocol('WM_DELETE_WINDOW', self.on_closing)

def main(title=None,msg=None,inistr=None,leng=20):
  obj = inentry(title=title,msg=msg,inistr=inistr,leng=leng)
  obj.root.wait_window(obj.root)
  return obj.result
  

#-------------------------------------------------
if __name__=='__main__':
  title,msg,inistr= 'タイトル文字列','メッセージ文字列','初期文字列'
  leng = 50
  inp = main(title=title,msg=msg,inistr=inistr,leng=leng)
  print(inp)
  
