#read_textfile_inc.py
'''
スクリプトなどのテキストファイルを読み込む。
戻り値：[<encoding>,<text>]
<encoding>:テキストファイルのエンコーディング 'utf-8','EUC^JP',..
<text>:テキスト（コーディングはプラットフォーム準拠）
'''
from chardet import detect
from tkinter import messagebox as mbx

def read_textfile(fpath):
  try:
    with open(fpath,'rb') as fp:
      bindata = fp.read()
    det = detect(bindata)
    with open(fpath,encoding=det['encoding']) as fp:
      txtdata = fp.read()
  except Exception as err:
    mbx.showerror('read_textfile():エラー',err)
    return []
  return [det['encoding'],txtdata]
