#dirfile_inc.py
'''
#-------------------------------------------
#Frozen環境を考慮してスクリプトの実行時ディレクトリを返す
def getscriptdir():
#------------------------------------------------
#ディレクトリ名とベース名等を結合する
def joinpath(dirname,basename):
#--------------------------------------------
#実行結果を表示する内部関数
def showresult(ttl,msgflg,res,parent=None):
#----------------------------------------------
#ファイル、ディレクトリの判定
def isfileordir(src,tgt=ThisisFile,msg=msgError,parent=None):
#-----------------------------------------------
#ディレクトリを作成（再帰的に深いディレクトリも作成）
def makedir(src,existok=True,msg=msgBoth,success_msg='Done.',parent=None):
#------------------------------------------------
#ディレクトリ削除（中のファイルを含めて削除）
def deletedir(src,msg=msgBoth,success_msg='Done.',parent=None):
#-------------------------------------------------
#ファイル削除
def deletefile(src,msg=msgBoth,success_msg='Done.',parent=None):
#--------------------------------------------------
#ディレクトリ・ファイルのリネーム
def renamedirfile(src,dest,msg=msgBoth,success_msg='Done.',parent=None):
#----------------------------------------------------
#ディレクトリ・ファイルの移動
def movedirfile(src,dest,msg=msgBoth,success_msg='Done.',parent=None):
#----------------------------------------------------
#ファイルコピー
def copyfile(src,dest,msg=msgBoth,success_msg='Done.',parent=None):
#------------------------------------------------------
#ディレクトリコピー
def dircopy(src,newdir,msg=msgBoth,success_msg='Done.',parent=None):
#-----------------------------------------------------
#カレントディレクトリの移動
def changdir(newdir,msg=msgBoth,success_msg='Done.',parent=None):
#------------------------------------------------------
#ファイルのタイムスタンプ変更
#
#timetpl:(atime,mtime) #unix_time----------------------
def settimestamp(fpath,timetpl=None,msg=msgBoth,
                 success_msg='Done.',parent=None):
#日時文字列で指定 '0000-00-00 00:00:00'-----------
def settimestamp_string(fpath,timetpl=None,msg=msgBoth,
                        success_msg='Done.',parent=None):
#datetimeオブジェクトで指定 -------------------
def settimestamp_datetime(fpath,timetpl=None,msg=msgBoth,
                          success_msg='Done',parent=None):
#------------------------------------------------------
#ファイル詳細を返す
def getfilestat(fpath):
#-----------------------------------------------------
#カレントディレクトリ名を返す
def curdir():
#-------------- filedialog ----------------------
#ディレクトリを選択
def opendir(title=None,inidir=None,parent=None):
#ファイルを選択
def openfname(title=None,inidir=None,inifile=None,parent=None):
#保存ファイル名選択
def savefname(title=None,inidir=None,inifile=None,parent=None):
#---------------------------------------------
#ディレクトリ・ファイルの存在確認
def is_exists(fpath=None):
#---------------------------------------------------
#ディレクトリ内のファイル一覧取得
def getfiles(dirpath=None,subdir=True,parent=None):

#ハードリンクはプラットフォームによって扱いが
異なるので当面作成しない
　ハードリンクの作成
　ハードリンクの削除
'''
from tkinter import *
from tkinter import messagebox as mbx
from tkinter import filedialog as fdlg
import os,sys
import datetime as dt
import shutil

#try_except_incは切り離す
#import try_except_inc as tei

#OSに対応したパスの区切り文字
Separater = os.sep

ThisisFile = 1
ThisisDir = 2

msgBoth = 1  #成功、失敗ともにメッセージを出力
msgError = 2 #失敗の場合のみメッセージを出力
msgNone = 0  #メッセージを出力しない

#-------------------------------------------
#Frozen環境を考慮してスクリプトの実行時ディレクトリを返す
#だたし、呼び出し元のスクリプトディレクトリではなく、
#このスクリプト自体のディレクトリを返すことに注意すること
def getscriptdir():
  if getattr(sys,'frozen',False):
    #sysオブジェクトにfrozenアトリビュートが存在すればその値が
    #frozenアトリビュートが存在しなければFalseが返る
    #Trueならfrozen環境
    return os.path.dirname(sys.executable)
  else:
    #frozen環境ではない。
    return os.path.dirname(os.path.realpath(__file__))

#------------------------------------------------
#ディレクトリ名とベース名等を結合する
#（結合後のパス名の存在確認はしない）
#プラットフォーム毎の区分文字を考慮して結合する
#os.sepの区分文字を使って結合しても結果は同じ
#basename:
#  ディレクトリを含む部分パスでもよいが、先頭文字が'/'の場合
#  結合されずにbasename部分だけが返される
def joinpath(dirname,basename):
  return os.path.join(dirname,basename)

#--------------------------------------------
#実行結果を表示する内部関数
#ttl: タイトル
#msgflg: msgBoth:1, msgError:2, msgNone:0
#res: [True|False,message]
#parent: 親window
def showresult(ttl,msgflg,res,parent=None):
  if msgflg:
    if res[0]: #True
      mbx.showinfo(ttl,res[1],parent=parent)
    else: #False
      mbx.showerror(ttl,res[1],parent=parent)
      
#----------------------------------------------
#ファイル、ディレクトリの判定
#src:ファイルパス
#tgt:ThisisFile(1) or ThisisDir(2) （ファイルかディレクトリかを問う）
#msg:msgBoth(1), msgError(2), msgNone(0)
#戻り値：[True|False,関数戻り値｜エラー内容]
def isfileordir(src,tgt=ThisisFile,msg=msgError,parent=None):
  if not os.path.exists(src):
    res = [False,'{}は存在しません'.format(src)]
    if msg == msgError: #エラーのみ結果表示
      mbx.showerror('isfileordir()',res[1],parent=parent)
    return res
  else:
    if tgt == ThisisFile:
      res = os.path.isfile(src)
    else:
      res = os.path.isdir(src)
    return [True,res]

#-----------------------------------------------
#ディレクトリを作成（再帰的に深いディレクトリも作成）
def makedir(src,existok=True,msg=msgBoth,success_msg='Done.',parent=None):
  try:
    os.makedirs(src,exist_ok=existok)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('makedir()',msg,res,parent)
  return res

#------------------------------------------------
#ディレクトリ削除（中のファイルを含めて削除）
def deletedir(src,msg=msgBoth,success_msg='Done.',parent=None):
  try:
    shutil.rmtree(src)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('deletdir()',msg,res,parent)
  return res

#-------------------------------------------------
#ファイル削除
def deletefile(src,msg=msgBoth,success_msg='Done.',parent=None):
  try:
    os.remove(src)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('deletefile()',msg,res,parent)
  return res

#--------------------------------------------------
#ディレクトリ・ファイルのリネーム
#movedirfile()とよく似た動作
#戻り値：[True|False,正常値|errorstr]
def renamedirfile(src,dest,msg=msgBoth,success_msg='Done.',parent=None):
  try:
    os.rename(src,dest)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('renamedirfile()',msg,res,parent)
  return res

#----------------------------------------------------
#ディレクトリ・ファイルの移動
##注意：
##  srcがディレクトリの場合：
##  ・destが既存の場合→srcを既存ディレクトリに移動
##  ・destが新規の場合→srcの中の中身だけをdestディレクトリに移動
##  srcがファイルの場合：
##  ・destがファイル名とみなされる場合→renameと同じ
##  ・destがディレクトリとみなされる場合(終端が'/')  ：
##      destが存在しない場合→エラー
##      destが存在する場合→destディレクトリに移動
#戻り値：[True|False,正常値|errorstr]
def movedirfile(src,dest,msg=msgBoth,success_msg='Done.',parent=None):
  try:
    shutil.move(src,dest)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('movedirfile()',msg,res,parent)
  return res

#----------------------------------------------------
#ファイルコピー
#src:ソースファイルパス名
#dest:コピー先ディレクトリ又はファイルパス名
#戻り値：[True|False,正常値|errorstr]
def copyfile(src,dest,msg=msgBoth,success_msg='Done.',parent=None):
  try:
    shutil.copy2(src,dest)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('copyfile()',msg,res,parent)
  return res

#------------------------------------------------------
#ディレクトリコピー
#src:ソースディレクトリ
#newdir:新規ディレクトル
#新規ディレクトリを作ってソースディレ内のファイルをコピーするので
#newdirに既存のディレクトリを指定するとエラーとなる
#戻り値：[True|False,正常値|errorstr]
def dircopy(src,newdir,msg=msgBoth,success_msg='Done.',parent=None):
  try:
    shutil.copytree(src,newdir)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('dircopy()',msg,res,parent)
  return res

#-----------------------------------------------------
#カレントディレクトリの移動
#戻り値：[True|False,正常値|errorstr]
def changdir(newdir,msg=msgBoth,success_msg='Done.',parent=None):
  try:
    os.chdir(newdir)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('changdir()',msg,res,parent)
  return res

#------------------------------------------------------
#ファイルのタイムスタンプ変更
#
#timetpl:(atime,mtime) #unix_time
def settimestamp(fpath,timetpl=None,msg=msgBoth,
                 success_msg='Done.',parent=None):
  try:
    os.utime(fpath,timetpl)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('settimestamp()',msg,res,parent)
  return res

#日時文字列で指定 '0000-00-00 00:00:00'-----------
def settimestamp_string(fpath,timetpl=None,msg=msgBoth,
                        success_msg='Done.',parent=None):
  try:
    #文字列をunixに変換して適用
    atime = dt.datetime.strptime(timetpl[0],'%Y-%m-%d %H:%M:%S').timestamp()
    mtime = dt.datetime.strptime(timetpl[1],'%Y-%m-%d %H:%M:%S').timestamp()
    timetpl = (atime,mtime)
    os.utime(fpath,timetpl)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('settilestamp_string()',msg,res,parent)
  return res

#datetimeオブジェクトで指定 -------------------
def settimestamp_datetime(fpath,timetpl=None,msg=msgBoth,
                          success_msg='Done',parent=None):
  try:
    #datetimeをunixに変換して適用
    atime = timetpl[0].timestamp()
    mtime = timetpl[1].timestamp()
    timetpl = (atime,mtime)
    os.utime(fpath,timetpl)
    res = [True,success_msg]
  except Exception as err:
    res = [False,str(err)]
  showresult('settimestamp_datetime',msg,res,parent)
  return res

#------------------------------------------------------
# filestat_inc.pyと同じ
#ファイル詳細を返す
def getfilestat(fpath):
  if not is_exists(fpath):
    return ''
  fstat = os.stat(fpath)
  fdata = {'path':fpath,'directory':os.path.dirname(fpath),
           'basename':os.path.basename(fpath),
           'ext':os.path.splitext(fpath)[1],
           'size':fstat.st_size,
           'row_atime':fstat.st_atime, #アクセス
           'fmt_atime':dt.datetime.fromtimestamp(fstat.st_atime).strftime(
             '%Y-%m-%d_%H:%M:%S(%a)'),
           'row_mtime':fstat.st_mtime, #更新
           'fmt_mtime':dt.datetime.fromtimestamp(fstat.st_mtime).strftime(
             '%Y-%m-%d_%H:%M:%S(%a)')}
  return fdata

#-----------------------------------------------------
#カレントディレクトリ名を返す
def curdir():
  return os.getcwd()

#-------------- filedialog ----------------------
#ディレクトリを選択
def opendir(title=None,inidir=None,parent=None):
  return fdlg.askdirectory(title=title,initialdir=inidir,parent=parent)

#ファイルを選択
def openfname(title=None,inidir=None,inifile=None,parent=None):
  return fdlg.askopenfilename(title=title,initialdir=inidir,
                              initialfile=inifile,parent=parent)

#保存ファイル名選択
def savefname(title=None,inidir=None,inifile=None,parent=None):
  return fdlg.asksaveasfilename(title=title,initialdir=inidir,
                                initialfile=inifile,parent=parent)
#------------------------------------------------

#ディレクトリ・ファイルの存在確認
def is_exists(fpath=None):
  return os.path.exists(fpath)

#ディレクトリ内のファイル一覧取得
#subdir:False サブディレクトリ以下は調査しない
#戻り値：[True|False,[(dirpath,dirs,files),..]]
def getfiles(dirpath=None,subdir=True,parent=None):
  fileslist = []
  if not is_exists(dirpath):
    mbx.showerror('getfiles()エラー','{}は存在しません'.format(dirpath),
                  parent=parent)
    return [False,fileslist]
  if not dirpath:
    return [False,fileslist]
  for dpath,dirs,files in os.walk(dirpath):
    fileslist.append((dpath,dirs,files))
    if not subdir:
      dirs.clear()
  return [True,fileslist]

#----------------------------------------------------------
if __name__=='__main__':
  #root = Tk()
  
  pass
