#scrollbar_inc.py
'''
#スクロールバー設置ラッパー

def scrollbarset()：
  簡易版
  スクロールバーを設置するウィジェットを事前に作成しておく
  ウィジェットやスクロールバーは.grid()でフレームに配置する
  戻り値：フレーム

def scrollbarset_grid():
  この関数の中で指定されたフレームとウィジェットを作成する
  （作成するフレームやウィジェットのオプションは辞書で渡す）
  ウィジェットやスクロールバーは.grid()でフレームに配置する
  戻り値：[フレーム、ウィジェット]

def scrollbarset_pack():
  互換性維持のために残している。
  実態は、引数そのままでscrollbarset_grid()をコールしているだけ。
  
  ※.grid()でTextウィジェットが空きスペース一杯に拡張しなかったのは
    w.grid_rowconfigure(),w.grid_columnconfigure()の指定をしていなかった
    のが原因だった。

class ScrlFrame:
  擬似的にFrameにスクロールバーを設置したもの。
  Frameには直接スクロールバーを設置できないので、Textウィジェットに
  スクロールバーを設置して、Textウィジェットにオブジェクトとしての
  Frameを貼り付けたもの。TextウィジェットはDISABLED状態なので
  編集はできないが、Textウィジェットに貼り付けたFrameにはウィジェットを
  貼り付けることができる。
  .result = [outframe, inframe]
  outframe：
    inframeとスクロールバーを含む全体のフレーム
    これをpack(),grid()で配置する必要がある
  inframe：
    ウィジェットを追加する対象のフレーム
  
'''

from tkinter import *

#　簡易版
#fr:対象ウィジェット'のみ'を含むフレームであること
#widget:対象のウィジェット(フレームに設置後のインスタンス)
#orient:VH=縦横 V=Y方向 H=X方向
#戻り値：fr
def scrollbarset(fr,widget,orient='VH'):
  if orient=='VH':
    vscrl = Scrollbar(fr,orient=VERTICAL,command=widget.yview)
    hscrl = Scrollbar(fr,orient=HORIZONTAL,command=widget.xview)
    widget['yscrollcommand'] = vscrl.set
    widget['xscrollcommand'] = hscrl.set
    widget.grid(row=0,column=0,sticky=N+S+W+E)
    vscrl.grid(row=0,column=1,sticky=N+S)
    hscrl.grid(row=1,column=0,sticky=W+E)
    fr.grid_rowconfigure(0,weight=1)
    fr.grid_rowconfigure(1,weight=0)
    fr.grid_columnconfigure(0,weight=1)
    fr.grid_columnconfigure(1,weight=0)
  elif orient == 'V':
    vscrl = Scrollbar(fr,orient=VERTICAL,command=widget.yview)
    widget['yscrollcommand'] = vscrl.set
    widget.grid(row=0,column=0,sticky=N+S+E+W)
    vscrl.grid(row=0,column=1,sticky=N+S)
    fr.grid_rowconfigure(0,weight=1)
    fr.grid_columnconfigure(0,weight=1)
    fr.grid_columnconfigure(1,weight=0)
  elif orient == 'H':
    hscrl = Scrollbar(fr,orient=HORIZONTAL,command=widget.xview)
    widget['xscrollcommand'] = hscrl.set
    widget.grid(row=0,column=0,sticky=N+S+E+W)
    hscrl.grid(row=1,column=0,sticky=W+E)
    fr.grid_rowconfigure(0,weight=1)
    fr.grid_rowconfigure(1,weight=0)
    fr.grid_columnconfigure(0,weight=1)
  return fr

#grid()バージョン
#parentの上にフレームとウィジェットを作成し、スクロールバーの設置を行う。
#parent:フレームを配置するウィンドウ
#FR:フレームクラス(Frame or LabelFrame)
#FRkw:フレーム定義のオプション辞書
#WDG:作成するウィジェットのクラス
#WDGkw:WDGクラス定義のオプションを辞書で与える
#fill:ウィジェットのfill設定 ='y','x','both'
#orient:スクロールバーの設置場所 VH=縦横,V=Y方向,H=X方向
#戻り値：[frame,widget]]
def scrollbarset_grid(parent,FR=Frame,FRkw={},WDG=None,WDGkw={},
                      fill='both',orient='VH'):
  basefr = FR(parent,**FRkw)
  widgetfr = Frame(basefr)
  widget = WDG(widgetfr,**WDGkw)
  if orient=='VH':
    vscrl = Scrollbar(widgetfr,orient=VERTICAL,command=widget.yview)
    hscrl = Scrollbar(widgetfr,orient=HORIZONTAL,command=widget.xview)
    widget['yscrollcommand'] = vscrl.set
    widget['xscrollcommand'] = hscrl.set
    #'''
    widget.grid(row=0,column=0,sticky=N+S+E+W)
    vscrl.grid(row=0,column=1,sticky=N+S)
    hscrl.grid(row=1,column=0,sticky=W+E)
    widgetfr.grid_rowconfigure(0,weight=1)
    widgetfr.grid_rowconfigure(1,weight=0)
    widgetfr.grid_columnconfigure(0,weight=1)
    widgetfr.grid_columnconfigure(1,weight=0)
    #
    widgetfr.pack(expand=True,fill='both')  #.grid()でも同じ？
    #'''
  elif orient == 'V':
    vscrl = Scrollbar(widgetfr,orient=VERTICAL,command=widget.yview)
    widget['yscrollcommand'] = vscrl.set
    #'''
    widget.grid(row=0,column=0,sticky=N+S+E+W)
    vscrl.grid(row=0,column=1,sticky=N+S)
    widgetfr.grid_rowconfigure(0,weight=1)
    widgetfr.grid_columnconfigure(0,weight=1)
    widgetfr.grid_columnconfigure(1,weight=0)
    #
    widgetfr.pack(expand=True,fill='both')  #.grid()でも同じ？
    #'''
  elif orient == 'H':
    hscrl = Scrollbar(basefr,orient=HORIZONTAL,command=widget.xview)
    widget['xscrollcommand'] = hscrl.set
    #'''
    widget.grid(row=0,column=0,sticky=N+S+E+W)
    hscrl.grid(row=1,column=0,sticky=W+E)
    widgetfr.grid_rowconfigure(0,weight=1)
    widgetfr.grid_rowconfigure(1,weight=0)
    widgetfr.grid_columnconfigure(0,weight=1)
    #
    widgetfr.pack(expand=True,fill='both')  #.grid()でも同じ？
    #'''
  return [basefr,widget]

#pack()バージョン 引数はgrid()バージョンと同じ
#実態は scrollbarset_grid()をそのまま呼び出しているだけ。互換性維持のため。
def scrollbarset_pack(parent,FR=Frame,FRkw={},WDG=None,WDGkw={},
                      fill='both',orient='VH'):
  return scrollbarset_grid(parent,FR=FR,FRkw=FRkw,WDG=WDG,
                           WDGkw=WDGkw,fill=fill,orient=orient)
  '''
  basefr = FR(parent,**FRkw)
  widgetfr = Frame(basefr)
  widget = WDG(widgetfr,**WDGkw)
  if orient=='VH':
    vscrl = Scrollbar(widgetfr,orient=VERTICAL,command=widget.yview)
    hscrl = Scrollbar(widgetfr,orient=HORIZONTAL,command=widget.xview)
    widget['yscrollcommand'] = vscrl.set
    widget['xscrollcommand'] = hscrl.set
    widget.pack(expand=True,fill=fill,side=LEFT)
    vscrl.pack(expand=True,fill='y')
    widgetfr.pack(expand=True,fill='both')
    hscrl.pack(expand=True,fill='x')
  elif orient == 'V':
    vscrl = Scrollbar(widgetfr,orient=VERTICAL,command=widget.yview)
    widget['yscrollcommand'] = vscrl.set
    widget.pack(expand=True,fill=fill,side=LEFT)
    widgetfr.pack(expand=True,fill='both')
    vscrl.pack(expand=True,fill='y')
  elif orient == 'H':
    hscrl = Scrollbar(basefr,orient=HORIZONTAL,command=widget.xview)
    widget['xscrollcommand'] = hscrl.set
    widget.pack(expand=True,fill=fill)
    widgetfr.pack(expand=True,fill='both')
    hscrl.pack(expand=True,fill='x')
  return [basefr,widget]
  '''

#--------------------------------------------
#スクロールバーのついたFrameクラス
#スクロールバーをつけたTextウィジェットにFrameを挿入したもの
#Textウィジェットに挿入するFrameは１つ
#FR:Frame or LabelFrame
#FRkw:Frame or LabelFrameのオプション辞書
#vFRkw:Textウィジェット上のFrameのオプション辞書
#vFRsize:Textウィジェット上のFrameのサイズ(初期値)のオプション辞書
#   実際はTextウィジェットの桁数と行数 {'width':桁数,'height':行数}
#   'width','height'以外のTextのオプションも記述できるが意味がない
#orient:スクロールバー設置位置：'VH'縦横, 'V'縦, 'H'横
class ScrlFrame:
  def __init__(self,parent,FR=Frame,FRkw={},vFRkw={},
               vFRsize={'width':20,'height':20},orient='VH'):
    #parent上にscrollbarset_pack()でスクロールバー付きのTextウィジェットを作成
    #self.basefrを呼び出し元でpack,gridで配置する
    self.basefr,self.textw = scrollbarset_grid(
      parent,FR=FR,FRkw=FRkw,WDG=Text,WDGkw=vFRsize,
      orient=orient)
    #TextウィジェットにFrameを挿入
    self.vFrame = Frame(self.textw,**vFRkw)
    #self.vFrame.pack(expand=1,fill=BOTH)  #不要：効果なし
    self.textw.window_create('0.0',window=self.vFrame)
    #TextがDISABLEDの状態でもFrameへのウィジェットの追加は可能
    self.textw['state'] = DISABLED
    self.result = [self.basefr,self.vFrame]

#-----------------------------------------------------
if __name__=='__main__':
  '''
  Frameはxview(),yview()を持っていないから、Frame自体には
  スクロールバーは設置できない。代用としてTextウィジェットに
  スクロールバーを設置して、その中にFrameを入れる。

  ググるとCanvasを使う方法が紹介されているが、どちらが使いやすいのか？
  '''
  root = Tk()
  sFr = ScrlFrame(root,FR=LabelFrame,
                  FRkw={'text':'LabelFrame','bg':'blue'},
                  vFRkw={'bg':'yellow'})
  base,myframe = sFr.result
  base.pack(expand=1,fill='both')

  Label(myframe,text='This is Label on frame in Text-widget',bg='white').pack()
  Button(myframe,text='ボタン').pack()
