#twinlistbox.py
#(test-Dialog-listboxdialog.py)

from tkinter import *
import scrollbar_inc as scrl
from tkinter import simpledialog as sim

'''
２つのリストボックスを表示して、それぞれ１つの項目を選択する。

Dialogから承継すると親ウィンドウの上に表示されてgrab_set()の効果で
モーダルダイアログになっている。そのため親ウィンドウのタイトルバーを
選択しても親ウィンドウが前面に来ることはない。
ただし、モーダル効果は限定的で親ウィンドウのコントロールを操作
できてしまう。
'''
class twinlistbox(sim.Dialog):
  #hei:リストボックスの高さ, wid:リストボックスの幅  Noneでデフォルト
  #llist,rlist:左右のリストボックスに挿入するデータのリスト
  #llbl,rlbl:左右のフレームに表示されるリストのタイトル
  #戻り値：self.result  [[左index,左選択項目],[右index,右選択項目]]
  #左右１つずつの選択が必須
  def __init__(self,parent=None,title=None, hei=10, wid=None,
               llist=None,rlist=None,llbl=None,rlbl=None):
    self.master = parent
    self.hei = hei
    self.wid = wid
    self.llbl = llbl
    self.rlbl = rlbl
    self.llist = llist
    self.rlist = rlist
    self.result = []
    #self.body()
    super().__init__(parent,title)
    
  def body(self,parent):
    #リストボックス用のフレームとボタン用のフレーム
    lrfr = Frame(self)
    lfr = LabelFrame(lrfr,text=self.llbl)
    self.leftlbx = Listbox(lfr,height=self.hei, width=self.wid,
                           selectmode=SINGLE)
    lfr = scrl.scrollbarset(lfr,self.leftlbx)
    #self.leftlbx.pack(padx=4,pady=4)
    lfr.pack(side=LEFT)
    rfr = LabelFrame(lrfr,text=self.rlbl)
    self.rightlbx = Listbox(rfr,height=self.hei,width=self.wid,
                            selectmode=SINGLE)
    rfr = scrl.scrollbarset(rfr,self.rightlbx)
    #self.rightlbx.pack(padx=4,pady=4)
    rfr.pack(side=LEFT)
    lrfr.pack(padx=5,pady=5)
    
    #左右の選択行を維持
    self.lidx = None
    self.ridx = None

    #リストボックスにアイテム挿入
    if self.llist:
      self.leftlbx.insert(0,*self.llist)
    if self.rlist:
      self.rightlbx.insert(0,*self.rlist)

    #選択行維持のためのバインド
    #<ButtonRelease>した段階で選択されるので
    self.leftlbx.bind('<ButtonRelease-1>',self.lkeepselected)
    self.rightlbx.bind('<ButtonRelease-1>',self.rkeepselected)
    #マウスの動きをこのウィンドウに制限したらどうか？
    
##  #ウィンドウサイズを固定
    self.resizable(False,False)

  #２つのリストで選択行が維持されたように見せる-----------
  def lkeepselected(self,ev):
    tpl = self.leftlbx.curselection()
    if not tpl or self.lidx == tpl[0]:
      return
    if self.lidx != None:
      # ''空文字で背景色クリア
      self.leftlbx.itemconfig(self.lidx,background='')
    self.lidx = tpl[0]
    self.leftlbx.itemconfig(self.lidx,background='gray75')

  def rkeepselected(self,ev):
    tpl = self.rightlbx.curselection()
    if not tpl or self.ridx == tpl[0]:
      return
    if self.ridx != None:
      # ''空文字で背景色クリア
      self.rightlbx.itemconfig(self.ridx,background='')
    self.ridx = tpl[0]
    self.rightlbx.itemconfig(self.ridx,background='gray75')

 
  def ok(self, event=None):
    if not self.validate():
      self.initial_focus.focus_set() # put focus back
      return

    self.withdraw()
    self.update_idletasks()

    try:
      self.apply()
    finally:
      self.cancel()


  def cancel(self, event=None):
    # put focus back to the parent window
    if self.parent is not None:
      self.parent.focus_set()
      self.destroy()


  def validate(self):
    if self.lidx == None or self.ridx == None:
      return False
    else:
      return True

  def apply(self):
    self.result = [[self.lidx,self.leftlbx.get(self.lidx)],
                   [self.ridx,self.rightlbx.get(self.ridx)]]

#-----------------------------------------------------------
if __name__=='__main__':
  import translate_inc as tr
  root = Tk()
  langlist = list(tr.langdic.keys())
  root.wait_visibility()
  twlbox = twinlistbox(root,title='テスト',llist=langlist,rlist=langlist,
                       llbl='原文言語',rlbl='翻訳言語')
  root.mainloop()
  print(twlbox.result)
  
