# translate_inc.py
# google_trans.gs(個人のgoogle apps script)を利用した翻訳関連の関数
# 
# 本家： https://script.google.com
#   本家サイトにログインして自作のスクリプトを作成・登録する。
#   翻訳などのgoogleが提供するAPIが利用できる。
#   利用したのはgoolge apps script(GAS)のLanguageApp
# 参考にしたサイト
#   https://qiita.com/satto_sann/items/be4177360a0bc3691fdf
#   https://qiita.com/tanabee/items/c79c5c28ba0537112922

#　GASの翻訳スクリプトのURLは実行時に指定する

import tkinter.messagebox as msgbox
import sys
import requests

#lang
##english = 'en'
##japanese = 'ja'
##chinese = 'zh-CN'
##korea = 'ko'
##french = 'fr'
##deutsch = 'de'  #ドイツ語
##itarian = 'it'
##russian = 'ru'
##espanol = 'es'  #スペイン語
##vietnamese = 'vi' #ベトナム語

#言語リスト
##langlist = [['日本語','ja'],['英語','en'],['中国語（簡体）','zh-CN'],
##            ['韓国語','ko'],['フランス語','fr'],['ドイツ語','de'],
##            ['イタリア語','it'],['ロシア語','ru'],['スペイン語','es'],
##            ['ベトナム語','vi']]

#言語辞書
langdic = {'日本語':'ja','英語':'en','中国語（簡体）':'zh-CN',
           '中国語（繁体）':'zh-TW','韓国語':'ko',
           'フランス語':'fr','ドイツ語':'de',
           'イタリア語':'it','ロシア語':'ru','スペイン語':'es',
           'スウェーデン語':'sv','ルーマニア語':'ro',
           'ウクライナ語':'uk','ポーランド語':'pl','ギリシャ語':'el',
           'フィンランド語':'fi','デンマーク語':'da','オランダ語':'nl',
           'ノルウェー語':'no','トルコ語':'tr','ベトナム語':'vi',
           'タガログ語（フィリピン語）':'tl','インドネシア語':'id',
           'ポルトガル語（ポルトガル、ブラジル）':'pt',
           'ラテン語':'la','ヒンディ語':'hi',}

#文末記号のreパターン
 #最後が.(ピリオド),?,!で終わっていなければ、次ブロックに継続
 # ブロック末文字を２つ追加：いずれも半角 　] " (2025.8.20)
 # ブロック末文字追加 ) (2025.9.2)
 # ブロック末文字追加 	।  (2025.11.1) ヒンディ語の文末
 #２バイト文字の場合も一応考慮
#eosptn = r'[^\)\]\"\.\?\!।。？！]$'
eosptn = r'[^\)\]\"\.\?\!।。？！]$'

def get_translated_text(url=None,srctext=None,
                        srclang=None,tgtlang=None,replcr=True):
  if not (url and srctext and srclang and tgtlang):
    msgbox.showerror('引数エラー','引数が指定されていません')
    #引数エラーメッセージ
    return None

  if replcr:
    srctext = adjustcr(srctext,srclang)
    # print(srctext)
    
  postdic = {'text':srctext,'source':srclang,'target':tgtlang}

  try:
    #ret = requests.post(url,data=postdic)
    ret = requests.get(url,params=postdic)
    if not ret.status_code == requests.codes.ok:
      msgbox.showerror('送信エラー',
                       '送信に失敗しました:{}'.format(ret.status.code))
      ret = None
      #sys.exit()
  except Exception as rqerr:
    msgbox.showerror('例外発生',rqerr)
    ret = None
    #sys.exit()

  if ret:
    return ret.text
  else:
    return ret


#原文テキストの改行位置を調整する
#　文の途中で改行があると誤って翻訳されるので
# 一先ず、改行をスペースに置き換えてみる
def adjustcr(text=None,lang=None):
  if not (text and lang):
    return ''
  return ' '.join(text.splitlines())


#＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝
if __name__=='__main__':
  #print(langdic)
  #gas scriptのurl入力
  import inputentry_inc as inp
  trans_url = inp.main(title='Google Apps Script',
                       msg='翻訳用GAS_scriptのURLを入力してください',
                       leng=50)
  if trans_url:
    srctext='''At the current time, we can build Kivy desktop
applications before building the mobile applications.
Let's start by building a hello world application.
The application shows a window that displays the "Hello World" text.'''

    res_text = get_translated_text(url=trans_url,srctext=srctext,
                                   srclang=langdic['英語'],
                                   tgtlang=langdic['日本語'])
                                   #,replcr=False)
    print(res_text)
